import os
import subprocess
from flask import Flask, request, redirect, render_template
from flask_httpauth import HTTPBasicAuth

app = Flask(__name__)
auth = HTTPBasicAuth()

users = {
    "admin": "admin",
}

HOME_DIR = '/home/dia/app'
#DIA_CONFIG_FILE = f'{HOME_DIR}/dia.config'
DIA_CONFIG_FILE = '../../dia.config'

@auth.verify_password
def verify_password(username, password):
    if username in users and users[username] == password:
        return username

@app.route('/')
@auth.login_required
def form():
    return redirect('/sip')

@app.route('/sip', methods=['GET', 'POST'])
@auth.login_required
def sip_form():
    if request.method == 'POST':
        save_sip_data(request.form)
        return 'Data saved!'
    
    elif request.method == 'GET':
        sound_devices = get_sound_devices()
        form_data = read_data_from_file(get_sip_data_dict())
        return render_template('sip_form.html' , sound_devices=sound_devices, form_data=form_data)

@app.route('/network', methods=['GET', 'POST'])
@auth.login_required
def network_form():
    if request.method == 'POST':
        save_network_data(request.form)
        os.system(f'sudo {HOME_DIR}/startup/load_wifi_network_info.sh')
        os.system(f'sudo {HOME_DIR}/startup/load_network_info.sh')
        return 'Data saved!'
    
    elif request.method == 'GET':
        form_data = read_data_from_file(get_network_data_dict())
        return render_template('network_form.html', form_data=form_data)

@app.route('/visual', methods=['GET', 'POST'])
@auth.login_required
def visual_form():
    if request.method == 'POST':
        save_visual_data(request.form)
        return 'Data saved!'
    
    elif request.method == 'GET':
        form_data = read_data_from_file(get_visual_data_dict())
        return render_template('visual_form.html', form_data=form_data)
    
@app.route('/reboot', methods=['GET', 'POST'])
@auth.login_required
def reboot_form():
    if request.method == 'POST':
        os.system('sudo reboot')
        return 'Rebooting...'

    return render_template('reboot_form.html')
    
@app.route('/save', methods=['POST'])
@auth.login_required
def save():
    text_data = request.form['textdata']
    with open('data.txt', 'w') as file:
        file.write(text_data)
    return 'Data saved!'


### Utility Functions ###

# START SIP Related Functions

def get_sound_devices():
    result = subprocess.run(['linphonecsh', 'soundcard', 'list'], stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)
    output = result.stdout.split('\n')
    soundcards = []
    for line in output:
        if line and not line.startswith('Error'):
            soundcards.append(line.strip())
    return soundcards

def get_sip_data_dict():
    return {
        "SIP_SERVER_URL": "",
        "SIP_USERNAME": "",
        "SIP_PASSWORD": "",
        "AUTO_ANSWER": "",
        "MICROPHONE_DEVICE": "",
        "SPEAKER_DEVICE": "",
        "RING_DEVICE": "",
        "SIP_EXT_NORMAL": "",
        "SIP_EXT_EMERGENCY": ""
    }

def save_sip_data(request_data):
    data = get_sip_data_dict()
    data["SIP_SERVER_URL"] = request_data.get("sip_server_url", "")
    data["SIP_USERNAME"] = request_data.get("sip_username", "")
    data["SIP_PASSWORD"] = request_data.get("sip_password", "")
    data["AUTO_ANSWER"] = request_data.get("auto_answer", "")
    data["MICROPHONE_DEVICE"] = request_data.get("microphone_device", "")
    data["SPEAKER_DEVICE"] = request_data.get("speaker_device", "")
    data["RING_DEVICE"] = request_data.get("ring_device", "")
    data["SIP_EXT_NORMAL"] = request_data.get("sip_ext_normal", "")
    data["SIP_EXT_EMERGENCY"] = request_data.get("sip_ext_emergency", "")
    save_data_to_file(data)

# END SIP Related Functions

# START Network Related Functions
def get_network_data_dict():
    return {
        "NETWORK_TYPE": "",
        "IP_ADDRESS": "",
        "SUBNET_MASK": "",
        "DEFAULT_GATEWAY": "",
        "WIRELESS_ENABLED": "",
        "WIRELESS_SSID": "",
        "WIRELESS_PASSWORD": ""
    }

def save_network_data(request_data):
    data = get_network_data_dict()
    data["NETWORK_TYPE"] = request_data.get("network_type", "")
    data["IP_ADDRESS"] = request_data.get("ip_address", "")
    data["SUBNET_MASK"] = request_data.get("subnet_mask", "")
    data["DEFAULT_GATEWAY"] = request_data.get("default_gateway", "")
    data["WIRELESS_ENABLED"] = request_data.get("wireless_enabled", "")
    data["WIRELESS_SSID"] = request_data.get("wireless_ssid", "")
    data["WIRELESS_PASSWORD"] = request_data.get("wireless_password", "")
    save_data_to_file(data)

# END Network Related Functions

# START Visual Related Functions
def get_visual_data_dict():
    return {
        "G2_DEVICE_ID": "",
        "VISUAL_VIEWER_BASE_URL": ""
    }

def save_visual_data(request_data):
    data = get_visual_data_dict()
    data["G2_DEVICE_ID"] = request_data.get("visual_device_id", "")
    data["VISUAL_VIEWER_BASE_URL"] = request_data.get("visual_viewer_base_url", "")
    save_data_to_file(data)

# END Visual Related Functions

# START Common Functions
def save_data_to_file(data):
    lines = []
    with open(DIA_CONFIG_FILE, 'r') as file:
        lines = file.readlines()

    for key, value in data.items():
        for index, line in enumerate(lines):
            line = line.strip()
            if key in line and not line.startswith("#"):
                lines[index] = f"{key}={value}\n"
                break

    with open(DIA_CONFIG_FILE, 'w') as file:
        file.writelines(lines)

def read_data_from_file(data_dict):
    with open(DIA_CONFIG_FILE, 'r') as file:
        for line in file:
            line = line.strip()
            for key in data_dict.keys():
                if key in line and not line.startswith("#"):
                    data_dict[key] = line.split("=")[1]

    return data_dict

# END Common Functions

if __name__ == '__main__':
    app.run(debug=True)