#!/bin/bash

# Ensure the script is run as root
if [[ $EUID -ne 0 ]]; then
   echo "This script must be run as root" 
   exit 1
fi

if [ "$ENVIRONMENT" = "DEV" ]; then
    # This path will only work when running the script from the startup directory. 
    # correct: ./start_linphone.sh
    # incorrect: startup/start_linphone.sh
    source ./load_dia_config.sh
else
    source /home/dia/app/startup/load_dia_config.sh
fi

# Wireless is enabled
if [ "$WIRELESS_ENABLED" = "1" ]; then
    # Check for required environment variables
    if [ -z "$WIRELESS_SSID" ] || [ -z "$WIRELESS_PASSWORD" ]; then
        echo "To configure a wireless network, set the WIRELESS_SSID and WIRELESS_PASSWORD environment variables."
        exit 1
    fi

    echo "Configuring wireless network: $WIRELESS_SSID"

    # Add a new Wi-Fi connection
    nmcli dev wifi connect "$WIRELESS_SSID" password "$WIRELESS_PASSWORD" ifname wlp1s0

    # Set the connection to be automatic
    nmcli connection modify "$WIRELESS_SSID" connection.autoconnect yes
fi

# Wireless is disabled. Delete all wireless connections.
if [ "$WIRELESS_ENABLED" = "0" ]; then
    echo "Disabling wireless network configuration."

    
    nmcli connection show | grep -i "wifi" | while read -r line ; do
        connection=$(echo "$line" | awk '{print $1}')
        echo "Deleting connection: $connection"
        nmcli connection delete "$connection"
    done
fi

echo "Wireless network configuration complete."